unit ucLogin;

interface

uses SysUtils, System.Data, System.Drawing, System.Web, System.Web.UI, System.Collections,
     System.Web.UI.WebControls, System.Web.UI.HtmlControls, System.Configuration,
     System.Web.Security;
     
type
    /// <summary>
    /// Summary description for WebUserControl1.
    /// </summary>
  TucLogin = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure LoginBtn_Click(sender: System.Object; e: System.Web.UI.ImageClickEventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    email: System.Web.UI.WebControls.TextBox;
    emailRequired: System.Web.UI.WebControls.RequiredFieldValidator;
    emailValid: System.Web.UI.WebControls.RegularExpressionValidator;
    password: System.Web.UI.WebControls.TextBox;
    passwordRequired: System.Web.UI.WebControls.RequiredFieldValidator;
    RememberLogin: System.Web.UI.WebControls.CheckBox;
    Message: System.Web.UI.WebControls.Label;
    LoginBtn: System.Web.UI.WebControls.ImageButton;
    cboDatabases: System.Web.UI.WebControls.DropDownList;
    procedure OnInit(e: System.EventArgs); override;
  private
    procedure BindDatabaseList;
  public
    { Public Declarations }
  end;

implementation

uses Helper, AdminDB, DBAlias, DBAliasCollection;

procedure TucLogin.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  if not Page.IsPostBack then
  begin
    email.Text := 'storeadmin@aspxdelphi.net';
    password.Attributes.Add('value', 'storeadmin');

    BindDatabaseList;
  end;
end;

procedure TucLogin.OnInit(e: System.EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TucLogin.LoginBtn_Click(sender: System.Object; e: System.Web.UI.ImageClickEventArgs);
var
  AdminDB : TAdminDB;
  AdminId : string;
  adminDetails : TadminDetails;
begin
    // Only attempt a login if all form fields on the page are valid
  if (Page.IsValid) AND (cboDatabases.SelectedIndex > 0) then
  begin
    //store DB alias
    Session.Add('TDBAlias',TDBAliasCollection.DBAlias(cboDatabases.selectedValue));


    // Attempt to Validate User Credentials using CustomersDB
    AdminDB := TAdminDB.Create;
    AdminId := AdminDB.Login(email.Text, password.Text);

    if (Assigned(AdminId)) AND (AdminID <> EmptyStr) then
    begin
      adminDetails := AdminDB.GetAdminDetails(AdminId);

      // Store the user's fullname in a cookie for personalization purposes
      //Response.Cookies[THelper.CookieName].Value := adminDetails.FullName;

      Response.Cookies[THelper.CookieName].Values.Add('adminName',adminDetails.FullName);
      Response.Cookies[THelper.CookieName].Values.Add('dbAliasName',TDBAlias(Session['TDBAlias']).Name);

      // Make the cookie persistent only if the user selects "persistent" login checkbox
      if (RememberLogin.Checked) then
        Response.Cookies[THelper.CookieName].Expires := DateTime.Now.AddMonths(1);

      // Redirect browser back to originating page
      FormsAuthentication.RedirectFromLoginPage(AdminId, RememberLogin.Checked);

    end
    else
    begin
      Message.Text := 'Login Failed!';
    end;
  end
  else
  begin
    Message.Text := 'Please select a database you want to administer!';
  end;
end;


{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TucLogin.InitializeComponent;
begin
  Include(Self.LoginBtn.Click, Self.LoginBtn_Click);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


procedure TucLogin.BindDatabaseList;
var
  ol : TDBAliasCollection;
begin
  ol := ConfigurationSettings.GetConfig('StoreAdminDatabases') as TDBAliasCollection;

  cboDatabases.DataSource := ol;
  cboDatabases.DataTextField := 'Name';
  cboDatabases.DataValueField := 'Name';
  cboDatabases.DataBind;

  cboDatabases.Items.Insert(0,'-- Select database by alias --');

end;

end.
